//Experiment-9
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : A SCILAB Program to find permissible frequency and length for limiting Ferranti effect in long transmission lines.


clc; 
clear all; // Clear All Variables & Command Window
Standard_f=50; 
l=400; 
VSLL=220e3;    //Defining Given DATA 
r=0.125; //Defining Given DATA 
x=0.4;  //Defining Given DATA 
y=%i*2.8e-6;          //Defining Given DATA 
R=r*l; 
X=x*l; 
Y=y*l; 
z=r+%i*x; 
Z=R+%i*X;
A=1+Y*Z/2; // Defining ABCD Parameters
B=Z*(1+Y*Z/6);            // Defining ABCD Parameters
C=Y*(1+Y*Z/6);  // Defining ABCD Parameters
D=A;                  // Defining ABCD Parameters

No_load_VRLL=VSLL/A;
NoLoad_VRLL=abs(No_load_VRLL)/1000        //Display No Load Voltage at Receiving
NoLoad_VR=NoLoad_VRLL/sqrt(3);       // Calculate Voltage per Phase
NoLoad_IS=abs(C*NoLoad_VR)           // Calculate Sending end Current

VRLL_MAX=235e3;                      // Define limit, the receiving end Volt
new_A=VSLL/VRLL_MAX;                 // Evaluate Parameter “A” for VRLL_MAX
l=sqrt(real((2*new_A-2)/y/z));       // Equation for maximum Length
Permisible_Lenth=abs(l)              // Find the Magnitude out of Complex

VRLL_MAX2=250e3;                     //  Similar to above
new_A2=VSLL/VRLL_MAX2;
Max_Permisible_f=abs((2500*sqrt(R^2*Y^2/10000+X*Y*(new_A2-1)/1250)-25*R*Y)/X/Y)

mprintf('No Load Voltage at Receiving end = %f kV \n\n', NoLoad_VRLL)
mprintf('No load Sending end Current = %f A \n\n', NoLoad_IS)
mprintf('Permissible length = %f Km \n\n',Permisible_Lenth)
mprintf('Max. Permissible Frequency = %f Hz \n\n', Max_Permisible_f)


//output:-
//
// No Load Voltage at Receiving end = 241.537811 kV 
//
//No load Sending end Current = 0.151528 A 
//
//Permissible length = 322.243754 Km 
//
//Max. Permissible Frequency = 63.678641 Hz 
